define([
    'underscore',
    'modules/page/popup/warning-popup-view',
    'text!modules/appointments/cancellation/cancellation.html',
], function (_, WarningPopupView, template) {
    'use strict';

    return WarningPopupView.extend({
        template: _.template(template),
        initialize: function(options) {
            this._modelType = options.modelType;
            this._initializeElAfterClose(options);
        },
        continue: function() {
            this.cancelAppointment();
        },
        cancelAppointment: function() {
            this.trigger('appointment:cancel:confirmed');
        },
        closePopup: function(e) {
            $('#' + this.id).popup('close');

            // only focus on element if "Continue" button not clicked,
            // because page is going to redraw on continue()
            if ($(e.currentTarget).is(':not(.warning-continue-btn)')) {
                this.focusOnElAfterClose();
            }
        },
        templateContext: function() {
            return {
                modelType: this._modelType,
                toTitleCase: function(string) {
                    return string.replace(/\w*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                },
            };
        },
    });
});
